function S = tanimotoSim(A,in,out)
% Calculate the tanimoto similarity matrix for an adjacency matrix A
% This is used by the linkCommunities algorithm.  A slightly different
% definition of Tanimoto similarity is used by the SimilarityMatrix
% algorithm

Aout = A;
Aout = Aout + diag(sum(Aout,2)./(sum(Aout>0,2)));
Aout(isnan(Aout)) = 0;

Ain = A;
Ain = Ain + diag(sum(Aout)'./sum(Ain>0)');
Ain(isnan(Ain)) = 0;
num = out.*(Aout * Aout') + in.*(Ain' * Ain);
N = size(A,1);

denom = repmat(diag(num)',[N 1]) + repmat(diag(num),[1 N]) - num;

S = num./denom;

end

